<?php
/**
 * Settings text strings
 * Contains all text strings used in the general settings sections of BookStack
 * including users and roles.
 */
return [

    // Common Messages
    'settings' => 'Настройки',
    'settings_save' => 'Сохранить настройки',
    'system_version' => 'Версия системы',
    'categories' => 'Категории',

    // App Settings
    'app_customization' => 'Настройки',
    'app_features_security' => 'Функционал и безопасность',
    'app_name' => 'Название приложения',
    'app_name_desc' => 'Название отображается в заголовках и сообщениях электронной почты отправленных системой.',
    'app_name_header' => 'Отображать название приложения в заголовке',
    'app_public_access' => 'Публичный доступ',
    'app_public_access_desc' => 'Включение этой опции позволит неавторизованным посетителям получить доступ к содержимому вашего BookStack.',
    'app_public_access_desc_guest' => 'Публичный доступ контролируется через настройки пользователя "Guest"',
    'app_public_access_toggle' => 'Разрешить публичный доступ',
    'app_public_viewing' => 'Разрешить публичный просмотр?',
    'app_secure_images' => 'Загрузка изображений с высоким уровнем безопасности',
    'app_secure_images_toggle' => 'Включить загрузку изображений с высоким уровнем безопасности',
    'app_secure_images_desc' => 'Для высокой производительности все изображения являются общедоступными. Этот параметр добавляет случайную строку перед URL изображения. Убедитесь, что индексация каталогов отключена, для предотвращения легкого доступа.',
    'app_default_editor' => 'Редактор страниц по умолчанию',
    'app_default_editor_desc' => 'Выберите, какой редактор будет использоваться по умолчанию при редактировании новых страниц. Это может быть переопределено на уровне страницы, где разрешены права.',
    'app_custom_html' => 'Пользовательский контент заголовка HTML',
    'app_custom_html_desc' => 'Любой контент, добавленный здесь, будет вставлен в нижнюю часть раздела <head> каждой страницы. Это удобно для переопределения стилей или добавления кода аналитики.',
    'app_custom_html_disabled_notice' => 'Пользовательский контент заголовка HTML отключен на этой странице, чтобы гарантировать отмену любых критических изменений.',
    'app_logo' => 'Логотип приложения',
    'app_logo_desc' => 'Используется в строке заголовка приложения, среди прочих областей. Это изображение должно быть 86px в высоте. Большие изображения будут масштабироваться вниз.',
    'app_icon' => 'Иконка приложения',
    'app_icon_desc' => 'Эта иконка используется для браузерных вкладок и иконок ярлыков. Должно быть 256px квадратное PNG изображение.',
    'app_homepage' => 'Стартовая страница приложения',
    'app_homepage_desc' => 'Выберите страницу, которая будет отображаться на главной странице вместо стандартной. Права на страницы игнорируются для выбранных страниц.',
    'app_homepage_select' => 'Выберите страницу',
    'app_footer_links' => 'Ссылки в нижней части страницы',
    'app_footer_links_desc' => 'Добавьте ссылки для отображения в нижнем колонтитуле сайта. Они будут отображаться в нижней части большинства страниц, включая те, которые не требуют входа. Вы можете использовать метку "trans::<key>" для использования системных переводов. Например: Использование "trans::common.privacy_policy" обеспечит перевод текста "Политика конфиденциальности" и "trans:common.terms_of_service" предоставит переведенный текст "Правила использования".',
    'app_footer_links_label' => 'Название ссылки',
    'app_footer_links_url' => 'Адрес ссылки',
    'app_footer_links_add' => 'Добавить ссылку',
    'app_disable_comments' => 'Отключение комментариев',
    'app_disable_comments_toggle' => 'Отключить комментарии',
    'app_disable_comments_desc' => 'Отключение комментариев на всех страницах. Существующие комментарии будут скрыты.',

    // Color settings
    'color_scheme' => 'Цветовая схема приложения',
    'color_scheme_desc' => 'Установите цвета для использования в пользовательском интерфейсе. Цвета могут быть настроены отдельно для темных и светлых режимов, чтобы наилучшим образом соответствовать теме и обеспечить разборчивость.',
    'ui_colors_desc' => 'Задайте основной цвет приложения и цвет ссылок по умолчанию. Основной цвет используется в основном для баннера заголовка, кнопок и декораций интерфейса. Цвет ссылок по умолчанию используется для текстовых ссылок и действий как в письменном содержании, так и в прикладном интерфейсе.',
    'app_color' => 'Основной цвет',
    'link_color' => 'Цвет ссылки',
    'content_colors_desc' => 'Задает цвета для всех элементов организационной иерархии страницы. Для удобства чтения рекомендуется выбирать цвета, яркость которых близка к цветам по умолчанию.',
    'bookshelf_color' => 'Цвет полки',
    'book_color' => 'Цвет книги',
    'chapter_color' => 'Цвет главы',
    'page_color' => 'Цвет страницы',
    'page_draft_color' => 'Цвет черновика страницы',

    // Registration Settings
    'reg_settings' => 'Настройки регистрации',
    'reg_enable' => 'Разрешить регистрацию',
    'reg_enable_toggle' => 'Разрешить регистрацию',
    'reg_enable_desc' => 'Если регистрация разрешена, пользователь сможет зарегистрироваться в системе самостоятельно. При регистрации назначается роль пользователя по умолчанию.',
    'reg_default_role' => 'Роль пользователя по умолчанию после регистрации',
    'reg_enable_external_warning' => 'Вышеуказанный параметр игнорируется, пока активна внешняя аутентификация LDAP или SAML. Учетные записи для несуществующих пользователей будут создаваться автоматически при условии успешной аутентификации на внешнем сервере.',
    'reg_email_confirmation' => 'Подтверждение электронной почты',
    'reg_email_confirmation_toggle' => 'Требовать подтверждение по электронной почте',
    'reg_confirm_email_desc' => 'При использовании ограничения по домену - подтверждение обязательно, этот пункт игнорируется.',
    'reg_confirm_restrict_domain' => 'Ограничить регистрацию по домену',
    'reg_confirm_restrict_domain_desc' => 'Введите список доменов почты через запятую, для которых разрешена регистрация. Пользователям будет отправлено письмо для подтверждения адреса перед входом в приложение. <br> Обратите внимание, что пользователи смогут изменить свой адрес после регистрации.',
    'reg_confirm_restrict_domain_placeholder' => 'Без ограничений',

    // Sorting Settings
    'sorting' => 'Lists & Sorting',
    'sorting_book_default' => 'Default Book Sort Rule',
    'sorting_book_default_desc' => 'Выберите правило сортировки по умолчанию для новых книг. Это не повлияет на существующие книги, и может быть изменено для каждой книги отдельно.',
    'sorting_rules' => 'Правила сортировки',
    'sorting_rules_desc' => 'Выберите правило сортировки по умолчанию для новых книг. Это не повлияет на существующие книги и может быть изменено для каждой книги отдельно.',
    'sort_rule_assigned_to_x_books' => 'Используется в :count книгах',
    'sort_rule_create' => 'Создать правило сортировки',
    'sort_rule_edit' => 'Edit Sort Rule',
    'sort_rule_delete' => 'Удалить правило сортировки',
    'sort_rule_delete_desc' => 'Удалить это правило сортировки из системы. Книги, использующие эту сортировку, вернутся к ручной сортировке.',
    'sort_rule_delete_warn_books' => 'This sort rule is currently used on :count book(s). Are you sure you want to delete this?',
    'sort_rule_delete_warn_default' => 'Это правило сортировки используется по умолчанию для книг. Вы уверены, что хотите удалить его?',
    'sort_rule_details' => 'Детали правила сортировки',
    'sort_rule_details_desc' => 'Set a name for this sort rule, which will appear in lists when users are selecting a sort.',
    'sort_rule_operations' => 'Sort Operations',
    'sort_rule_operations_desc' => 'Configure the sort actions to be performed by moving them from the list of available operations. Upon use, the operations will be applied in order, from top to bottom. Any changes made here will be applied to all assigned books upon save.',
    'sort_rule_available_operations' => 'Доступные операции',
    'sort_rule_available_operations_empty' => 'No operations remaining',
    'sort_rule_configured_operations' => 'Configured Operations',
    'sort_rule_configured_operations_empty' => 'Перетащите/добавьте операции из списка "Доступные операции"',
    'sort_rule_op_asc' => '(Возрастание)',
    'sort_rule_op_desc' => '(Убывание)',
    'sort_rule_op_name' => 'Name - Alphabetical',
    'sort_rule_op_name_numeric' => 'По нумерации',
    'sort_rule_op_created_date' => 'Created Date',
    'sort_rule_op_updated_date' => 'Updated Date',
    'sort_rule_op_chapters_first' => 'Chapters First',
    'sort_rule_op_chapters_last' => 'Главы в конце',
    'sorting_page_limits' => 'Per-Page Display Limits',
    'sorting_page_limits_desc' => 'Set how many items to show per-page in various lists within the system. Typically a lower amount will be more performant, while a higher amount avoids the need to click through multiple pages. Using an even multiple of 3 (18, 24, 30, etc...) is recommended.',

    // Maintenance settings
    'maint' => 'Обслуживание',
    'maint_image_cleanup' => 'Очистка изображений',
    'maint_image_cleanup_desc' => 'Сканирует содержимое страниц и предыдущих версий и определяет изображения, которые не используются. Убедитесь, что у вас есть резервная копия базы данных и папки изображений перед запуском этой функции.',
    'maint_delete_images_only_in_revisions' => 'Также удалять изображения, которые существуют только в старой версии страницы',
    'maint_image_cleanup_run' => 'Выполнить очистку',
    'maint_image_cleanup_warning' => 'Найдено :count возможно бесполезных изображений. Вы уверены, что хотите удалить эти изображения?',
    'maint_image_cleanup_success' => ':count возможно бесполезных изображений было найдено и удалено!',
    'maint_image_cleanup_nothing_found' => 'Не найдено ни одного бесполезного изображения!',
    'maint_send_test_email' => 'Отправить тестовое письмо',
    'maint_send_test_email_desc' => 'Отправить тестовое письмо на адрес электронной почты, указанный в профиле.',
    'maint_send_test_email_run' => 'Отправить письмо',
    'maint_send_test_email_success' => 'Письмо отправлено на :address',
    'maint_send_test_email_mail_subject' => 'Проверка электронной почты',
    'maint_send_test_email_mail_greeting' => 'Доставка электронной почты работает!',
    'maint_send_test_email_mail_text' => 'Поздравляем! Поскольку вы получили это письмо, электронная почта настроена правильно.',
    'maint_recycle_bin_desc' => 'Удаленные полки, книги, главы и страницы отправляются в корзину, чтобы они могли быть восстановлены или удалены навсегда. Более старые элементы в корзине могут быть автоматически удалены через некоторое время в зависимости от системной конфигурации.',
    'maint_recycle_bin_open' => 'Открыть корзину',
    'maint_regen_references' => 'Пересоздать ссылки',
    'maint_regen_references_desc' => 'Это действие восстановит перекрёстный справочный индекс в базе данных. Обычно это действие обрабатывается автоматически, но оно может быть полезно для индексации старого контента или контента, добавляемого неофициальными методами.',
    'maint_regen_references_success' => 'Справочный индекс был обновлен!',
    'maint_timeout_command_note' => 'Примечание: Это действие может занять время для запуска, что может привести к возникновению проблем в некоторых web-средах. В качестве альтернативы, это действие можно выполнить с помощью терминальной команды.',

    // Recycle Bin
    'recycle_bin' => 'Корзина',
    'recycle_bin_desc' => 'Здесь вы можете восстановить удаленные элементы или навсегда удалить их из системы. Этот список не отфильтрован в отличие от аналогичных списков действий в системе, где применяются фильтры.',
    'recycle_bin_deleted_item' => 'Удаленный элемент',
    'recycle_bin_deleted_parent' => 'Родительский объект',
    'recycle_bin_deleted_by' => 'Удалён',
    'recycle_bin_deleted_at' => 'Время удаления',
    'recycle_bin_permanently_delete' => 'Удалить навсегда',
    'recycle_bin_restore' => 'Восстановить',
    'recycle_bin_contents_empty' => 'На данный момент корзина пуста',
    'recycle_bin_empty' => 'Очистить корзину',
    'recycle_bin_empty_confirm' => 'Это действие навсегда уничтожит все элементы в корзине, включая содержимое, содержащееся в каждом элементе. Вы уверены, что хотите очистить корзину?',
    'recycle_bin_destroy_confirm' => 'Это действие навсегда удалит этот элемент из системы, вместе с любыми дочерними элементами, перечисленными ниже, и вы не сможете восстановить этот контент. Вы уверены, что хотите навсегда удалить этот элемент?',
    'recycle_bin_destroy_list' => 'Элементы для удаления',
    'recycle_bin_restore_list' => 'Элементы для восстановления',
    'recycle_bin_restore_confirm' => 'Это действие восстановит удаленный элемент, включая дочерние, в исходное место. Если исходное место было удалено и теперь находится в корзине, родительский элемент также необходимо будет восстановить.',
    'recycle_bin_restore_deleted_parent' => 'Родитель этого элемента также был удален. Элементы будут удалены до тех пор, пока этот родитель не будет восстановлен.',
    'recycle_bin_restore_parent' => 'Восстановить родительский объект',
    'recycle_bin_destroy_notification' => 'Удалено :count элементов из корзины.',
    'recycle_bin_restore_notification' => 'Восстановлено :count элементов из корзины',

    // Audit Log
    'audit' => 'Журнал аудита',
    'audit_desc' => 'Этот журнал аудита отображает список действий, отслеживаемых в системе. Этот список не отфильтрован в отличие от аналогичных списков действий в системе, где применяются фильтры.',
    'audit_event_filter' => 'Фильтр событий',
    'audit_event_filter_no_filter' => 'Без фильтра',
    'audit_deleted_item' => 'Удаленный элемент',
    'audit_deleted_item_name' => 'Имя: :name',
    'audit_table_user' => 'Пользователь',
    'audit_table_event' => 'Событие',
    'audit_table_related' => 'Связанный элемент',
    'audit_table_ip' => 'IP-адрес',
    'audit_table_date' => 'Дата действия',
    'audit_date_from' => 'Диапазон даты от',
    'audit_date_to' => 'Диапазон даты до',

    // Role Settings
    'roles' => 'Роли',
    'role_user_roles' => 'Роли пользователей',
    'roles_index_desc' => 'Роли используются для группировки пользователей и предоставления системных разрешений их участникам. Когда пользователь является членом нескольких ролей, предоставленные разрешения объединяются, и пользователь наследует все возможности.',
    'roles_x_users_assigned' => ':count пользователь назначен|:count назначенных пользователей',
    'roles_x_permissions_provided' => ':count разрешение|:count разрешений',
    'roles_assigned_users' => 'Назначенные пользователи',
    'roles_permissions_provided' => 'Предоставленные разрешения',
    'role_create' => 'Добавить роль',
    'role_delete' => 'Удалить роль',
    'role_delete_confirm' => 'Это удалит роль с именем \':roleName\'.',
    'role_delete_users_assigned' => 'Эта роль назначена :userCount пользователям. Если вы хотите перенести их, выберите новую роль ниже.',
    'role_delete_no_migration' => "Не переносить пользователей",
    'role_delete_sure' => 'Вы уверены что хотите удалить данную роль?',
    'role_edit' => 'Редактировать роль',
    'role_details' => 'Детали роли',
    'role_name' => 'Название роли',
    'role_desc' => 'Краткое описание роли',
    'role_mfa_enforced' => 'Требует многофакторной аутентификации',
    'role_external_auth_id' => 'Внешние ID авторизации',
    'role_system' => 'Системные разрешения',
    'role_manage_users' => 'Управление пользователями',
    'role_manage_roles' => 'Управление ролями и правами на роли',
    'role_manage_entity_permissions' => 'Управление правами на все книги, главы и страницы',
    'role_manage_own_entity_permissions' => 'Управление разрешениями для собственных книг, глав и страниц',
    'role_manage_page_templates' => 'Управление шаблонами страниц',
    'role_access_api' => 'Доступ к системному API',
    'role_manage_settings' => 'Управление настройками приложения',
    'role_export_content' => 'Экспорт контента',
    'role_import_content' => 'Import content',
    'role_editor_change' => 'Изменение редактора страниц',
    'role_notifications' => 'Получение и управление уведомлениями',
    'role_permission_note_users_and_roles' => 'These permissions will technically also provide visibility & searching of users & roles in the system.',
    'role_asset' => 'Права доступа к материалам',
    'roles_system_warning' => 'Имейте в виду, что доступ к любому из указанных выше трех разрешений может позволить пользователю изменить свои собственные привилегии или привилегии других пользователей системы. Назначать роли с этими правами можно только доверенным пользователям.',
    'role_asset_desc' => 'Эти разрешения контролируют доступ по умолчанию к параметрам внутри системы. Разрешения на книги, главы и страницы перезапишут эти разрешения.',
    'role_asset_admins' => 'Администраторы автоматически получают доступ ко всему контенту, но эти опции могут отображать или скрывать параметры пользовательского интерфейса.',
    'role_asset_image_view_note' => 'Это относится к видимости в менеджере изображений. Фактический доступ к загруженным файлам изображений будет зависеть от опции хранения системных изображений.',
    'role_asset_users_note' => 'These permissions will technically also provide visibility & searching of users in the system.',
    'role_all' => 'Все',
    'role_own' => 'Владелец',
    'role_controlled_by_asset' => 'Контролируется активом, в который они загружены',
    'role_save' => 'Сохранить роль',
    'role_users' => 'Пользователи с данной ролью',
    'role_users_none' => 'Нет пользователей с данной ролью',

    // Users
    'users' => 'Пользователи',
    'users_index_desc' => 'Создание и управление индивидуальными учетными записями пользователей в системе. Учетные записи пользователя используются для входа и атрибуции контента и активности. Разрешения доступа в первую очередь основываются на роли, но владельцы контента могут влиять на разрешения и доступ.',
    'user_profile' => 'Профиль пользователя',
    'users_add_new' => 'Добавить пользователя',
    'users_search' => 'Поиск пользователей',
    'users_latest_activity' => 'Последние действия',
    'users_details' => 'Данные пользователя',
    'users_details_desc' => 'Укажите имя и адрес электронной почты для этого пользователя. Адрес электронной почты будет использоваться для входа в приложение.',
    'users_details_desc_no_email' => 'Задайте имя для этого пользователя, чтобы другие могли его узнать.',
    'users_role' => 'Роли пользователя',
    'users_role_desc' => 'Назначьте роли пользователю. Если назначено несколько ролей, разрешения будут суммироваться и пользователь получит все права назначенных ролей.',
    'users_password' => 'Пароль пользователя',
    'users_password_desc' => 'Установите пароль для входа в приложение. Длина пароля должна быть не менее 8 символов.',
    'users_send_invite_text' => 'Вы можете отправить этому пользователю письмо с приглашением, которое позволит ему установить пароль самостоятельно или задайте пароль сами.',
    'users_send_invite_option' => 'Отправить пользователю письмо с приглашением',
    'users_external_auth_id' => 'Внешний ID аутентификации',
    'users_external_auth_id_desc' => 'Когда используется внешняя система аутентификации (например, SAML2, OIDC или LDAP), этот идентификатор будет использоваться для связывания пользователя BookStack с учетной записью системы аутентификации. Вы можете игнорировать это поле, если используете стандартную аутентификацию по электронной почте.',
    'users_password_warning' => 'Заполните поля ниже только если вы хотите изменить пароль.',
    'users_system_public' => 'Этот пользователь представляет любых гостевых пользователей, которые посещают ваше приложение. Он не может использоваться для входа в систему и назначается автоматически.',
    'users_delete' => 'Удалить пользователя',
    'users_delete_named' => 'Удалить пользователя :userName',
    'users_delete_warning' => 'Это полностью удалит пользователя \':userName\' из системы.',
    'users_delete_confirm' => 'Вы уверены что хотите удалить этого пользователя?',
    'users_migrate_ownership' => 'Наследник контента',
    'users_migrate_ownership_desc' => 'Выберите пользователя, если вы хотите, чтобы он стал владельцем всех элементов, в настоящее время принадлежащих удаляемому пользователю.',
    'users_none_selected' => 'Пользователь не выбран',
    'users_edit' => 'Редактировать пользователя',
    'users_edit_profile' => 'Редактировать профиль',
    'users_avatar' => 'Аватар пользователя',
    'users_avatar_desc' => 'Выберите изображение. Изображение должно быть квадратным, размером около 256px.',
    'users_preferred_language' => 'Предпочитаемый язык',
    'users_preferred_language_desc' => 'Этот параметр изменит язык интерфейса приложения. Это не влияет на созданный пользователем контент.',
    'users_social_accounts' => 'Аккаунты социальных сетей',
    'users_social_accounts_desc' => 'Просмотр статуса подключенных социальных учетных записей для этого пользователя. Учетные записи социальных сетей могут использоваться в дополнение к системе первичной аутентификации для доступа к системе.',
    'users_social_accounts_info' => 'Здесь вы можете подключить другие учетные записи для более быстрого и легкого входа в систему. Отключение учетной записи здесь не возможно. Отмените доступ к настройкам вашего профиля в подключенном социальном аккаунте.',
    'users_social_connect' => 'Подключить аккаунт',
    'users_social_disconnect' => 'Отключить аккаунт',
    'users_social_status_connected' => 'Подключен',
    'users_social_status_disconnected' => 'Отключен',
    'users_social_connected' => ':socialAccount аккаунт успешно подключен к вашему профилю.',
    'users_social_disconnected' => ':socialAccount аккаунт успешно отключен от вашего профиля.',
    'users_api_tokens' => 'API токены',
    'users_api_tokens_desc' => 'Создание и управление токенами доступа, используемыми для аутентификации с помощью BookStack REST API. Разрешения для API управляются пользователем, которому принадлежит токен.',
    'users_api_tokens_none' => 'Для этого пользователя не создано API токенов',
    'users_api_tokens_create' => 'Создать токен',
    'users_api_tokens_expires' => 'Истекает',
    'users_api_tokens_docs' => 'Документация',
    'users_mfa' => 'Многофакторная аутентификация',
    'users_mfa_desc' => 'Многофакторная аутентификация повышает степень безопасности вашей учетной записи.',
    'users_mfa_x_methods' => 'методов настроено :count|методов сконфигурировано :count',
    'users_mfa_configure' => 'Настройка методов',

    // API Tokens
    'user_api_token_create' => 'Создать токен',
    'user_api_token_name' => 'Имя',
    'user_api_token_name_desc' => 'Присвойте вашему токену читаемое имя, в качестве напоминания о его назначении в будущем.',
    'user_api_token_expiry' => 'Истекает',
    'user_api_token_expiry_desc' => 'Установите дату истечения срока действия этого токена. После наступления даты запросы, сделанные с использованием данного токена, больше не будут работать. Если оставить это поле пустым, срок действия истечет через 100 лет.',
    'user_api_token_create_secret_message' => 'Сразу после создания этого токена будут сгенерированы и отображены идентификатор токена и секретный ключ. Секретный ключ будет показан только один раз, поэтому перед продолжением обязательно скопируйте значение в безопасное и надежное место.',
    'user_api_token' => 'API токен',
    'user_api_token_id' => 'Идентификатор токена',
    'user_api_token_id_desc' => 'Это нередактируемый системный идентификатор для этого токена, который необходимо указывать в запросах API.',
    'user_api_token_secret' => 'Секретный ключ',
    'user_api_token_secret_desc' => 'Это сгенерированный системой секретный ключ для этого токена, который необходимо будет указывать в запросах API. Он будет показан только один раз, поэтому скопируйте это значение в безопасное и надежное место.',
    'user_api_token_created' => 'Токен создан :timeAgo',
    'user_api_token_updated' => 'Токен обновлён :timeAgo',
    'user_api_token_delete' => 'Удалить токен',
    'user_api_token_delete_warning' => 'Это полностью удалит API токен с именем \':tokenName\' из системы.',
    'user_api_token_delete_confirm' => 'Вы уверены, что хотите удалить этот API токен?',

    // Webhooks
    'webhooks' => 'Вебхуки',
    'webhooks_index_desc' => 'Webhooks - это способ посылать данные на внешние URL-адреса при возникновении определенных действий и событий в системе, которые позволяют интегрировать события с внешними платформами, такими как системы обмена сообщениями или уведомлениями.',
    'webhooks_x_trigger_events' => ':count событие триггера|:count событий триггера',
    'webhooks_create' => 'Создать вебхук',
    'webhooks_none_created' => 'Вебхуки еще не созданы.',
    'webhooks_edit' => 'Редактировать вебхук',
    'webhooks_save' => 'Сохранить вебхук',
    'webhooks_details' => 'Детали вебхука',
    'webhooks_details_desc' => 'Укажите удобное для пользователя название и адрес для отправки данных вебхука с помощью POST.',
    'webhooks_events' => 'События вебхука',
    'webhooks_events_desc' => 'Выберите все события, которые должны вызывать этот вебхук.',
    'webhooks_events_warning' => 'Имейте в виду, что эти события будут срабатывать для всех выбранных событий, даже если применяются пользовательские разрешения. Убедитесь, что использование этого вебхука не будет раскрывать конфиденциальные данные.',
    'webhooks_events_all' => 'Все системные события',
    'webhooks_name' => 'Имя вебхука',
    'webhooks_timeout' => 'Таймаут запроса Webhook (секунды)',
    'webhooks_endpoint' => 'Конечная точка вебхука',
    'webhooks_active' => 'Вебхук активен',
    'webhook_events_table_header' => 'События',
    'webhooks_delete' => 'Удалить вебхук',
    'webhooks_delete_warning' => 'Это полностью удалит этот вебхук с названием \':webhookName\' из системы.',
    'webhooks_delete_confirm' => 'Вы уверены, что хотите удалить этот вебхук?',
    'webhooks_format_example' => 'Пример вебхука',
    'webhooks_format_example_desc' => 'Данные вебхука отправляются как POST запрос к настроенной конечной точке в виде JSON в соответствии с форматом ниже. Свойства "related_item" и "url" необязательны и зависят от типа вызванного события.',
    'webhooks_status' => 'Состояние Webhook',
    'webhooks_last_called' => 'Последний вызов:',
    'webhooks_last_errored' => 'Последняя ошибка:',
    'webhooks_last_error_message' => 'Последнее сообщение об ошибке:',

    // Licensing
    'licenses' => 'Лицензии',
    'licenses_desc' => 'Эта страница содержит сведения о лицензиях для BookStack в дополнение к проектам и библиотекам, которые используются в BookStack. Многие перечисленные проекты могут использоваться только в контексте разработки.',
    'licenses_bookstack' => 'Лицензия BookStack',
    'licenses_php' => 'Лицензии PHP библиотек',
    'licenses_js' => 'Лицензии JavaScript библиотек',
    'licenses_other' => 'Прочие лицензии',
    'license_details' => 'Подробности о лицензии',

    //! If editing translations files directly please ignore this in all
    //! languages apart from en. Content will be auto-copied from en.
    //!////////////////////////////////
    'language_select' => [
        'en' => 'English',
        'ar' => 'العربية',
        'bg' => 'Bǎlgarski',
        'bs' => 'Bosanski',
        'ca' => 'Català',
        'cs' => 'Česky',
        'cy' => 'Cymraeg',
        'da' => 'Dansk',
        'de' => 'Deutsch (Sie)',
        'de_informal' => 'Deutsch (Du)',
        'el' => 'ελληνικά',
        'es' => 'Español',
        'es_AR' => 'Español Argentina',
        'et' => 'Eesti keel',
        'eu' => 'Euskara',
        'fa' => 'فارسی',
        'fi' => 'Suomi',
        'fr' => 'Français',
        'he' => 'עברית',
        'hr' => 'Hrvatski',
        'hu' => 'Magyar',
        'id' => 'Bahasa Indonesia',
        'it' => 'Italian',
        'ja' => '日本語',
        'ko' => '한국어',
        'lt' => 'Lietuvių Kalba',
        'lv' => 'Latviešu Valoda',
        'nb' => 'Norsk (Bokmål)',
        'ne' => 'नेपाली',
        'nn' => 'Nynorsk',
        'nl' => 'Nederlands',
        'pl' => 'Polski',
        'pt' => 'Português',
        'pt_BR' => 'Português do Brasil',
        'ro' => 'Română',
        'ru' => 'Русский',
        'sk' => 'Slovensky',
        'sl' => 'Slovenščina',
        'sv' => 'Svenska',
        'tr' => 'Türkçe',
        'uk' => 'Українська',
        'uz' => 'O‘zbekcha',
        'vi' => 'Tiếng Việt',
        'zh_CN' => '简体中文',
        'zh_TW' => '繁體中文',
    ],
    //!////////////////////////////////
];
